/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.handlers;

import com.ibm.hwmca.base.rsf.handlers.BaseRsfHandlersErrorIds;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestImpl;
import com.ibm.hwmca.base.rsf.requests.BaseRsfResultDetails;
import com.ibm.hwmca.base.rsf.requests.SdrAdditionalData;
import com.ibm.hwmca.base.rsf.requests.SdrHttpRequest;
import com.ibm.hwmca.base.rsf.requests.SdrHttpResponse;
import com.ibm.hwmca.base.rsf.sas.CredentialUtils;
import com.ibm.hwmca.base.rsf.util.TcpConnection;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.rcs.path.RcsPath;
import com.ibm.hwmca.fw.rcs.sas.SysInfo;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Socket;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSocket;

public class SdrUtils
implements BaseRsfHandlersErrorIds {
    private static final String TRACE_MASKT = "XRSFSDRT";
    private static final String TRACE_MASKF = "XRSFSDRF";
    private static final String TRACE_MASKD = "XRSFSDRD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "SdrHandler");
    private static FrameworkLogAttributes infoLog = FrameworkLogAttributes.INFO_LOG;
    private static FrameworkLogAttributes infoLogDisplayError = new FrameworkLogAttributes(false, false, true, true, true, true, false, 0);
    private static String addCredentialMethod = "ESAUpdateCredentials";
    private static String addCredentialClass = "com.ibm.hwmca.p.sa.ServiceAgentUtils";
    private static String applicationSSL = "/support/electronic/itssdr/IESproxy.wss";
    private static String applicationLegacy = "/servlet/SDR";
    private static File tempPath = null;
    static /* synthetic */ Class class$java$lang$String;

    public static SdrHttpResponse sendSdrRequest(RcsPath path, TcpConnection connection, SdrHttpRequest httpRequest, SysInfo owning, SysInfo sending, BaseRsfResultDetails details, BaseRsfRequestImpl request) throws IOException {
        String xml = httpRequest.getXmlData();
        Trace.trace(TRACE_MASKT, "-> SdrUtils.sendSdrRequest(Connection= " + connection + "request= " + xml + ")");
        Socket socket = connection.getSocket();
        boolean isSSL = false;
        if (socket instanceof SSLSocket) {
            isSSL = true;
        }
        File file = httpRequest.getDataFile();
        if (xml == null || xml.trim().length() == 0) {
            return new SdrHttpResponse(4, null, null, null, null, httpRequest);
        }
        long fileSize = 0L;
        boolean fileReady = false;
        File tempFile = null;
        String tempFileName = null;
        if (file != null) {
            String filename = file.getAbsolutePath();
            try {
                tempFile = File.createTempFile("iqy", ".tmp", tempPath);
                tempFileName = tempFile.getAbsolutePath();
            }
            catch (IOException ioe) {
                SdrUtils.logErrorAndContinue("SdrUtils.readFile: Cannot create temp file", ioe, (short)28449);
                return new SdrHttpResponse(1, null, null, null, null, httpRequest);
            }
            if (request.isLocalRequest()) {
                Trace.trace(TRACE_MASKD, "SdrUtils.readFile: copying local file for send to RETAIN");
                try {
                    FileUtilities.copy(filename, tempFileName);
                }
                catch (Exception e) {
                    SdrUtils.logErrorAndContinue("SdrUtils.readFile: Unable to copy file locally: " + filename, e, (short)28449);
                    return new SdrHttpResponse(1, null, null, null, null, httpRequest);
                }
            } else {
                Trace.trace(TRACE_MASKD, "SdrUtils.readFile: transferring remote file for send to RETAIN");
                if (!request.getFile(tempFileName, filename, true)) {
                    SdrUtils.logErrorAndContinue("SdrUtils.readFile: Unable to transfer file from submitting machine", null, (short)28449);
                    return new SdrHttpResponse(1, null, null, null, null, httpRequest);
                }
            }
            fileSize = tempFile.length();
            Trace.trace(TRACE_MASKF, "File [" + file + "] has fileLength = " + fileSize);
            if (!tempFile.canRead()) {
                Trace.trace(TRACE_MASKF, " can not read fileName [" + file + "]");
                return new SdrHttpResponse(1, null, null, null, null, httpRequest);
            }
        }
        if ((xml = SdrUtils.addCredentials(xml, owning, sending)) == null) {
            return new SdrHttpResponse(5, null, null, null, null, httpRequest);
        }
        long dataSize = fileSize + (long)xml.length();
        String sessionlessRequest = SdrUtils.createHttpHeader(dataSize, isSSL);
        StringBuffer response = new StringBuffer(1000);
        BufferedReader bufferedReader = null;
        PrintStream printStream = null;
        printStream = new PrintStream(socket.getOutputStream());
        printStream.print(sessionlessRequest);
        printStream.print(xml);
        if (fileSize > 0L) {
            boolean eof = false;
            int recordNumber = 0;
            int bytesRead = 0;
            long bytesRemaining = fileSize;
            Trace.trace(TRACE_MASKD, "fileSize = " + fileSize);
            FileInputStream dataStream = new FileInputStream(tempFile);
            while (!eof || bytesRemaining > 0L) {
                byte[] buffer = bytesRemaining > 4000L ? new byte[4000] : new byte[(int)bytesRemaining];
                ++recordNumber;
                bytesRead = dataStream.read(buffer);
                if (bytesRead > 0) {
                    Trace.trace(TRACE_MASKD, "writing file record number " + recordNumber + ", bytes remaining = " + (bytesRemaining -= (long)bytesRead));
                    printStream.write(buffer, 0, buffer.length);
                    continue;
                }
                eof = true;
            }
            printStream.flush();
            if (tempFile != null) {
                tempFile.delete();
            }
        }
        bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        String httpHeader = "";
        String line = null;
        boolean firstTime = true;
        int lineCount = 0;
        while ((line = bufferedReader.readLine()) != null) {
            Trace.trace(TRACE_MASKD, "SdrUtils.sendSdrRequest(): line = " + ++lineCount + " [" + line + "]");
            if (line.length() == 0 && firstTime) {
                httpHeader = new String(response);
                response.setLength(0);
                firstTime = false;
                continue;
            }
            if (line.indexOf("sessionless-sdr-return-v2.dtd") < 0) {
                response.append(line);
                response.append("\r\n");
                continue;
            }
            int begin = line.indexOf("SYSTEM");
            int end = line.lastIndexOf("\"");
            line = line.substring(0, begin) + line.substring(end + 1, line.length());
            response.append(line);
            response.append("\r\n");
        }
        printStream.close();
        bufferedReader.close();
        socket.close();
        StringTokenizer stringTokenizer = new StringTokenizer(httpHeader, " ");
        String stringResponse = response.toString();
        if (stringTokenizer.countTokens() < 3) {
            return new SdrHttpResponse(2, stringResponse, null, null, null, httpRequest);
        }
        stringTokenizer.nextToken();
        String httpReturnCode = stringTokenizer.nextToken();
        String httpReturnMessage = stringTokenizer.nextToken("\n");
        String xmlRc = SdrUtils.getXmlRc(stringResponse);
        String message = "SdrUtils: rc from SdrHttpRequest=" + xmlRc;
        if (xmlRc == null) {
            Trace.trace(TRACE_MASKF, "SdrUtils.sendSdrRequest: null xml rc");
        } else if (xmlRc.equals("7100") || xmlRc.equals("7150")) {
            SdrUtils.logErrorAndContinue(message + ". Owning system credential failure.", null, (short)28482);
            details.setReasonCode(15);
            details.setErrLogMsg(message + ". This indicates an unknown owning system identifier or invalid password.");
        } else if (xmlRc.equals("7101") || xmlRc.equals("7151")) {
            CredentialUtils.clearLocalCredentials();
            SdrUtils.logErrorAndContinue(message + ". Sending system credential failure. Local credential cleared.  Will retry", null, (short)28482);
            details.setReasonCode(16);
            details.setErrLogMsg(message + ". This indicates an unknown sending system identifier or invalid password.");
        } else if (xmlRc.equals("7180")) {
            SdrUtils.logErrorAndContinue(message + ". Owning system password expired.", null, (short)28482);
            details.setReasonCode(15);
            details.setErrLogMsg(message + ". This indicates the password expired on the owning system");
        } else if (xmlRc.equals("7181")) {
            CredentialUtils.clearLocalCredentials();
            SdrUtils.logErrorAndContinue(message + ". Sending system password expired.  Local credential cleared.  Will retry", null, (short)28482);
            details.setReasonCode(16);
            details.setErrLogMsg(message + ". This indicates the password expired on the sending system");
        }
        Trace.trace(TRACE_MASKF, "SdrUtils.sendSdrRequest(): HTTP return code = " + httpReturnCode);
        return new SdrHttpResponse(0, stringResponse, httpReturnCode, httpReturnMessage, xmlRc, httpRequest);
    }

    public static String createHttpHeader(long contentLength, boolean ssl) {
        Trace.trace(TRACE_MASKT, "-> SdrUtils.createHttpHeader(" + contentLength + ")");
        String applName = ssl ? applicationSSL : applicationLegacy;
        String httpHeader = "POST " + applName + " " + "HTTP/" + "1.0" + "\r\n" + "Content-Type: " + "application/octet-stream" + "\r\n" + "Content-Length: " + contentLength + "\r\n" + "Accept: text/*, application/octet-stream\r\n" + "X-XML-Document-Name: sessionless-sdr-request-v2\r\n" + "X-XML-Character-Encoding: UTF8\r\n" + "\r\n";
        Trace.trace(TRACE_MASKT, "<- SdrUtils.createHttpHeader()");
        return httpHeader;
    }

    private static String getXmlRc(String xml) {
        Trace.trace(TRACE_MASKT, "-> SdrUtils::getXmlRc()");
        Object returnXml = null;
        Class<?> implClass = null;
        try {
            implClass = Class.forName(addCredentialClass);
        }
        catch (ClassNotFoundException e) {
            Trace.trace(TRACE_MASKT, "<- SdrUtils.getXmlRc() returning null, implementation class not found for " + addCredentialClass);
            return null;
        }
        try {
            SdrAdditionalData data = (SdrAdditionalData)implClass.newInstance();
            return data.extractXmlRc(xml);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "getXmlRc: SdrAdditionalData implementation not found.");
            return null;
        }
    }

    private static String addCredentials(String xml, SysInfo owningCredentials, SysInfo sendingCredentials) {
        Trace.trace(TRACE_MASKT, "-> SdrUtils::addCredentials()");
        String returnXml = null;
        Class<?> implClass = null;
        try {
            implClass = Class.forName(addCredentialClass);
        }
        catch (ClassNotFoundException e) {
            Trace.trace(TRACE_MASKT, "<- SdrUtils.addCredentials() returning null, implementation class not found for " + addCredentialClass);
            return null;
        }
        try {
            SdrAdditionalData data = (SdrAdditionalData)implClass.newInstance();
            String result = data.updateConnectionInfo(xml, null, sendingCredentials.getMachineId(), sendingCredentials.getPassword(), owningCredentials.getMachineId(), owningCredentials.getPassword(), "VPN", null, null);
            if (result == null || result.trim().length() == 0) {
                return xml;
            }
            return result;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "addCredentials: SdrAdditionalData implementation not found.  Trying static method");
            Class[] fiveString = new Class[5];
            for (int i = 0; i < 5; ++i) {
                fiveString[i] = class$java$lang$String == null ? SdrUtils.class$("java.lang.String") : class$java$lang$String;
            }
            Method factory = null;
            try {
                factory = implClass.getDeclaredMethod(addCredentialMethod, fiveString);
            }
            catch (NoSuchMethodException e2) {
                Trace.trace(TRACE_MASKT, "<- SdrUtils.addCredentials() returning null, no '" + addCredentialMethod + "' method found in impl class for " + addCredentialClass);
                return null;
            }
            int mod = factory.getModifiers();
            if (factory.getReturnType() != (class$java$lang$String == null ? (class$java$lang$String = SdrUtils.class$("java.lang.String")) : class$java$lang$String) || !Modifier.isPublic(mod) || !Modifier.isStatic(mod)) {
                Trace.trace(TRACE_MASKT, "<- SdrUtils.addCredentials() returning null, return type or modifiers for '" + addCredentialMethod + "' are wrong in class " + addCredentialClass);
                return null;
            }
            Object[] parms = new String[]{xml, sendingCredentials.getMachineId(), sendingCredentials.getPassword(), owningCredentials.getMachineId(), owningCredentials.getPassword()};
            try {
                returnXml = (String)factory.invoke(null, parms);
                Trace.trace(TRACE_MASKT, "<- SdrUtils.addCredentials() Ok for " + addCredentialClass);
                return returnXml;
            }
            catch (Exception e3) {
                Trace.trace(TRACE_MASKT, "<- SdrUtils.addCredentials() returning null, invocation of " + addCredentialMethod + " threw an exception.");
                Trace.trace(TRACE_MASKT, e3);
                return null;
            }
        }
    }

    private static void logErrorAndContinue(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLogDisplayError);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            tempPath = new File(BaseFileControl.getFilePath("tmp"));
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "ZPapHandler: static block - Unable to get temp file path");
            new FrameworkLog(logInfo, 28451, e).log(infoLog);
        }
    }
}

